import { world, ItemStack } from '@minecraft/server'

world.afterEvents.itemUse.subscribe((data) => {
    const player = data.source
    const selectedItem = player.getComponent('equippable').getEquipment('Mainhand')
    if (selectedItem?.typeId === 'v360:ancient_whistle' && !player.getItemCooldown('ancient_whistle')) {
        player.startItemCooldown('ancient_whistle', 100)
        player.runCommandAsync('damage @e[r=10,family=!player] 4')
        player.runCommandAsync('effect @e[r=10,family=!player] slowness 5 3 true')
        player.runCommandAsync('effect @e[r=10,family=!player] poison 5 3 true')
        player.runCommandAsync('playsound item.ancient_whistle.whistle @a ~~~ 1 1')
        player.runCommandAsync('particle v360:ancient_whistle ~~1~')
    }
})